<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Smart Invoice System
 *
 * A simple and powerful web app based on PHP CodeIgniter framework manage invoices.
 *
 * @package Smart Invoice System
 * @author  Bessem Zitouni (bessemzitouni@gmail.com)
 * @copyright   Copyright (c) 2017
 * @since   Version 1.6.0
 * @filesource
 */
$lang['IS_RTL']                           = false;
$lang['lang']                             = "de";
$lang['site_title_head']                  = 'Smart Invoice System';
$lang['site_title']                       = 'Smart <span class="bold">Invoice</span> System';
$lang['is_demo']                          = "Dies ist eine Demo-Version, können Sie nicht alle Optionen ausführen";
$lang['remove_install_file']              = "Für die Sicherheit des Programms löschen Sie bitte die Installationsdatei &quot;install.php&quot; aus dem Hauptordner";

$lang['invoice']                          = 'Rechnung';
$lang['invoices']                         = 'Rechnungen';
$lang['invoices_subheading']              = 'Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.';
$lang['reference']                        = 'Referenz';
$lang['date']                             = 'Datum';
$lang['date_due']                         = 'Geburtstermin';
$lang['valid_till']                       = 'Gültig bis';
$lang['status']                           = 'Status';
$lang['invoice_note']                     = "Rechnungsnotiz";
$lang['invoice_terms']                    = "Rechnungsbedingungen";
$lang['total']                            = 'Gesamt';
$lang['actions']                          = 'Aktionen';
$lang['details']                          = 'Details';
$lang['delete']                           = 'Löschen';
$lang['edit']                             = 'Bearbeiten';
$lang['duplicate']                        = 'Duplikat';
$lang['refresh']                          = 'Erneuern';
$lang['filter']                           = 'Filter';
$lang['yes']                              = 'Ja';
$lang['no']                               = 'Nein';
$lang['ok']                               = 'OK';
$lang['cancel']                           = "Stornieren";
$lang['clear']                            = "Klar";
$lang['save']                             = "sparen";
$lang['next']                             = "Nächster";
$lang['previous']                         = "Bisherige";
$lang['confirmation']                     = 'Bestätigung';
$lang['alert_confirmation']               = 'Sie wollen diese Aktion bestätigen. Drücken Sie YES, um fortzufahren oder NEIN, um zurückzukehren';
$lang['name']                             = 'Name';
$lang['description']                      = 'Beschreibung';
$lang['show_description']                 = 'Beschreibung anzeigen';

$lang["system"]                           = 'System';
$lang['create_invoice']                   = 'Rechnung erstellen';
$lang['edit_invoice']                     = "Rechnung bearbeiten";
$lang['create_invoice_subheading']        = "Um eine neue Rechnung zu erstellen, geben Sie bitte die nachfolgenden Informationen ein.";
$lang['edit_invoice_subheading']          = "Um diese Rechnung zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['preview_invoice_error']            = "Um diese Rechnung zu sehen, geben Sie bitte alle benötigten Informationen ein.";
$lang['invoice_title']                    = "Rechnungsbezeichnung";
$lang['invoice_description']              = "Geben Sie die Rechnungsübersicht ein ...";
$lang['basic_informations']               = "Grundlegende Informationen";
$lang['contact_informations']             = "Kontaktinformationen";
$lang['account_informations']             = "Kontoinformationen";
$lang['additional_informations']          = "Weitere Informationen";
$lang['attn']                             = "Attn";
$lang['company']                          = "Unternehmen";
$lang['company_name']                     = "Name der Firma";
$lang['fullname']                         = "Vollständiger Name";
$lang['contact_name']                     = "Kontaktname";
$lang['phone']                            = "Telefon";
$lang['email']                            = "Email";
$lang['address']                          = "Adresse";
$lang['percent']                          = "Prozent (%)";
$lang['flat']                             = "Wohnung ($)";
$lang['off']                              = "Aus";
$lang['invoice_setting']                  = "Rechnungseinstellungen";
$lang['currency']                         = "Währung";
$lang['tax_type']                         = "Steuerart";
$lang['discount_type']                    = "Rabattart";
$lang['tax']                              = "Steuer";
$lang['taxes']                            = "Steuern";
$lang['discount']                         = "Rabatt";
$lang['discounts']                        = "Ermäßigungen";
$lang['total_due']                        = "Gesamt fällig";
$lang['issued_on']                        = "Ausgegeben am";
$lang['issued_date']                      = "Ausgabedatum";

$lang['all_invoices']                     = "Alle Rechnungen";
$lang['unpaid']                           = "Unbezahlt";
$lang['paid']                             = "Bezahlt";
$lang['partial']                          = "Teilweise";
$lang['due']                              = "Fällig";
$lang['overdue']                          = "Überfällig";
$lang['canceled']                         = "Abgebrochen";
$lang['draft']                            = "Entwurf";

$lang['due_receipt']                      = "-";
$lang['after_7_days']                     = "Nach 7 Tagen";
$lang['after_15_days']                    = "Nach 15 Tagen";
$lang['after_30_days']                    = "Nach 30 Tagen";
$lang['after_45_days']                    = "Nach 45 Tagen";
$lang['after_60_days']                    = "Nach 60 Tagen";
$lang['custom']                           = "Benutzerdefiniertes Datum";

$lang['more']                             = "Mehr ...";
$lang['add']                              = "Hinzufügen";
$lang['quantity']                         = "Anzahl";
$lang['unit_price']                       = "Einzelpreis";
$lang['add_row']                          = "Zeile hinzufügen";
$lang['subtotal']                         = "Zwischensumme";
$lang['global_tax']                       = "Globale Steuer";
$lang['global_discount']                  = "Globaler Rabatt";
$lang['preview']                          = "Vorschau";
$lang['create']                           = "Erstellen";
$lang['open']                             = "Öffnen";
$lang['invoice_no']                       = "Rechnungsnummer";
$lang['invoice_items']                    = "Rechnungspositionen";
$lang['n°']                               = "N °";
$lang['code']                             = "Code";
$lang['print']                            = "Drucken";
$lang['close']                            = "Schließen";
$lang['title']                            = "Titel";
$lang['system_setting']                   = "Systemeinstellung";
$lang['system_setting_subheading']        = "Um die Systemeinstellungen zu aktualisieren, geben Sie bitte die unten stehenden Informationen ein.";
$lang['settings_general']                 = "Einstellungen Allgemeines";
$lang['settings_company']                 = "Einstellungen Unternehmen";
$lang['settings_invoice']                 = "Einstellungen Rechnung";
$lang['configuration_general']            = "General";
$lang['update_settings']                  = "Update Einstellungen";
$lang['language']                         = "Sprache";
$lang['select']                           = "Wählen";
$lang['selected']                         = "Ausgewählt";
$lang['date_format']                      = "Datumsformat";
$lang['currency_format']                  = "Währungsformat";
$lang['currency_format']                  = "Währungsformat";
$lang['default_currency']                 = "Standardwährung";
$lang['currency_place']                   = "Währung symbole Ort";
$lang['prefix_invoice']                   = "Rechnungspräfix";
$lang['estimate_prefix']                  = "Präfix schätzen";
$lang['receipt_prefix']                   = "Zahlungspräfix";
$lang['contract_prefix']                  = "Vertragspräfix";
$lang['expense_prefix']                   = "Kostenpräfix";
$lang['invoice_next']                     = "Nächste Rechnung";
$lang['estimate_next']                    = "Nächste Schätzung";
$lang['receipt_next']                     = "Nächste Beleg";
$lang['contract_next']                    = "Nächster Vertrag";
$lang['expense_next']                     = "Nächste Ausgabe";
$lang['biller_type']                      = "Biller Typ";
$lang['item_tax']                         = "Kurtaxe";
$lang['item_discount']                    = "Artikel Rabatt";
$lang['is_required']                      = "Wird benötigt";
$lang['email_address']                    = "E-Mail-Addresse";
$lang['city']                             = "Stadt";
$lang['state']                            = "Bundesland";
$lang['postal_code']                      = "Postleitzahl";
$lang['country']                          = "Land";
$lang['website']                          = "Webadresse";
$lang['configuration_company']            = "Unternehmen";
$lang['update']                           = "Aktualisieren";
$lang['logo']                             = "Logo";
$lang['perview']                          = "Vorschau";
$lang['configuration_invoice_template']   = "Rechnungsvorlage";
$lang['update_template']                  = "Vorlage aktualisieren";
$lang['settings']                         = "Einstellungen";
$lang['style']                            = "Stil";
$lang['header']                           = "Header";
$lang['footer']                           = "Fußzeile";
$lang['signature']                        = "Unterschrift";
$lang['template_configuration']           = "Vorlagenkonfiguration";
$lang['default_layout']                   = "Standardlayout";
$lang['default_size']                     = "Standardgröße";
$lang['auto_print']                       = "Automatischer Druck";
$lang['template_style_configuration']     = "Vorlagenstil";
$lang['font']                             = "Schriftart";
$lang['table_bordered']                   = "Tischgrenze";
$lang['table_striped']                    = "Tisch gestreift";
$lang['primary_color']                    = "Primärfarbe";
$lang['second_color']                     = "Sekundärfarbe";
$lang['template_header_configuration']    = "Vorlagenkopf";
$lang['appearance']                       = "Das Auftreten";
$lang['show_header']                      = "Anzeigen Ausblenden";
$lang['header_bg_color']                  = "Header Hintergrundfarbe";
$lang['header_txt_color']                 = "Header-Textfarbe";
$lang['template']                         = "Vorlage";
$lang['header_text']                      = "Überschrift";
$lang['template_footer_configuration']    = "Vorlage footer";
$lang['show_footer']                      = "Anzeigen Ausblenden";
$lang['footer_bg_color']                  = "Footer Hintergrundfarbe";
$lang['footer_txt_color']                 = "Footer Textfarbe";
$lang['footer_text']                      = "Fusszeile";
$lang['template_signature_configuration'] = "Vorlage Unterschrift";
$lang['signature_txt']                    = "Unterschriftstext";
$lang['order_by']                         = "Sortieren nach";
$lang['title_invoice']                    = "Titelrechnung";
$lang['no_zero_required']                 = "Feld %s Wird benötigt";
$lang['users']                            = 'Benutzer';
$lang['dashboard']                        = 'Instrumententafel';
$lang['settings_general_updated']         = "Die allgemeinen Einstellungen werden erfolgreich aktualisiert";
$lang['settings_company_updated']         = "Die Firmeneinstellungen werden erfolgreich aktualisiert";
$lang['invoice_template_updated']         = "Die Rechnungsvorlageneinstellungen werden erfolgreich aktualisiert";
$lang['invoice_add_success']              = "Rechnung erfolgreich erstellt";
$lang['invoice_edit_success']             = "Rechnung erfolgreich aktualisiert";
$lang['invoice_deleted']                  = "Rechnung erfolgreich gelöscht";
$lang['cant_delete_invoice']               = "Sie können diese Rechnung nicht löschen! Ursache: <br><ul><li> Diese Rechnung bezieht sich auf andere Gegenstände </li></ul> Sie müssen alle Artikel löschen und dann erneut versuchen";
$lang['invoice_duplicate_success']        = "Rechnung erfolgreich dupliziert";
$lang['access_denied']                    = "Zugriff abgelehnt!";
$lang['language_is_changed']              = "Sprache wird erfolgreich geändert";
$lang['change_password']                  = "Passwort ändern";
$lang['logout']                           = "Ausloggen";
$lang['here']                             = "Hier";

$lang['paid_invoices']                    = "Bezahlte Rechnung (en)";
$lang['unpaid_invoices']                  = "Unbezahlte Rechnungen)";
$lang['overdue_invoices']                 = "Überfällige Rechnung (en)";
$lang['number_of_invoices']               = '<div class="font-weight-bold"> %s </div><div class="text-muted"> <small>Rechnungen</small> </div>';
$lang['last_invoices']                    = "Letzte Rechnungen";
$lang['last_invoices_subheading']         = "Liste der letzten 5 erstellten Rechnungen anzeigen";
$lang['overview_chart']                   = "Übersichtskarte";
$lang['overview_chart_subheading']        = "Kreisdiagramm, der Rechnungen pro Status zählt";
$lang['invoices_per_date']                = "Rechnungen pro Datum";
$lang['invoices_per_date_subheading']     = "line-Diagramm, das die Summe der Rechnungen pro Datum anzeigt";

$lang['settings_template']                = "Vorlage";
$lang['defaults']                         = "Vorgaben";
$lang['default_status']                   = "Standardstatus";
$lang['manage_configurations']            = "Erstellen und Aktualisieren von Konfigurationen";
$lang['printing_configurations']          = "Druckkonfigurationen";
$lang['show_invoice_status']              = "Rechnungsstatus anzeigen";
$lang['show_total_due']                   = "Gesamtsumme anzeigen";
$lang['show_payments_page']               = "Zahlungen anzeigen";
$lang['note_terms_on_page']               = "Begriffe auf Seite";
$lang['enable_terms']                     = "Begriffe aktivieren";
$lang['payments_total']                   = "Zahlungen insgesamt";
$lang['invoice_total']                    = "Rechnungsbetrag";
$lang['description_inline']               = "Produktbeschreibung";
$lang['description_inline_tip']           = "Produktbeschreibung auf derselben Zeile mit Namen anzeigen";

// Errors
$lang['error_csrf']                       = 'Diese Formularpost hat unsere Sicherheitskontrollen nicht bestanden.';
// Users Roles
$lang['role_superadmin']                  = 'Super Admin';
$lang['role_admin']                       = 'Administrator';
$lang['role_members']                     = 'Benutzer (Mitglied)';
$lang['role_customer']                    = 'Kunde';
$lang['role_supplier']                    = 'Lieferant';

// Login
$lang['login_heading']                    = 'Anmeldung';
$lang['login_subheading']                 = 'Bitte melden Sie sich mit Ihrem E-Mail / Benutzernamen und Passwort an.';
$lang['login_identity_label']             = 'Email / Benutzername';
$lang['login_password_label']             = 'Passwort';
$lang['login_remember_label']             = 'Erinnere dich an mich';
$lang['login_submit_btn']                 = 'Anmeldung';
$lang['login_forgot_password']            = 'Haben Sie Ihr Passwort vergessen?';

// Index
$lang['index_heading']                    = 'Benutzer';
$lang['index_subheading']                 = 'Unten ist eine Liste der Benutzer.';
$lang['index_username_th']                = 'Benutzername';
$lang['index_name_th']                    = 'Name';
$lang['index_fname_th']                   = 'Vorname';
$lang['index_lname_th']                   = 'Familienname, Nachname';
$lang['index_email_th']                   = 'Email';
$lang['index_groups_th']                  = 'Gruppen';
$lang['index_status_th']                  = 'Status';
$lang['index_action_th']                  = 'Aktion';
$lang['index_active_link']                = 'Aktivieren';
$lang['index_inactive_link']              = 'Inaktivieren';
$lang['index_create_user_link']           = 'Erstellen Sie einen neuen Benutzer';
$lang['index_active_status']              = 'Aktiv';
$lang['index_inactive_status']            = 'Inaktiv';

// Deactivate User
$lang['deactivate_heading']                  = 'Benutzer deaktivieren';
$lang['deactivate_subheading']               = 'Sind Sie sicher, dass Sie den Benutzer deaktivieren möchten. %s \ &#39;';
$lang['deactivate_confirm_y_label']          = 'Ja';
$lang['deactivate_confirm_n_label']          = 'Nein';
$lang['deactivate_submit_btn']               = 'einreichen';
$lang['deactivate_validation_confirm_label'] = 'Bestätigung';
$lang['deactivate_validation_user_id_label'] = 'Benutzeridentifikation';

// Create User
$lang['create_user_heading']                           = 'Benutzer erstellen';
$lang['create_user_subheading']                        = 'Bitte geben Sie die untenstehenden Informationen ein.';
$lang['create_user_fname_label']                       = 'Vorname';
$lang['create_user_lname_label']                       = 'Familienname, Nachname';
$lang['create_user_company_label']                     = 'Name der Firma';
$lang['create_user_identity_label']                    = 'Identität';
$lang['create_user_email_label']                       = 'Email';
$lang['create_user_phone_label']                       = 'Telefon';
$lang['create_user_password_label']                    = 'Passwort';
$lang['create_user_password_confirm_label']            = 'Bestätige das Passwort';
$lang['create_user_submit_btn']                        = 'Benutzer erstellen';
$lang['create_user_validation_fname_label']            = 'Vorname';
$lang['create_user_validation_lname_label']            = 'Familienname, Nachname';
$lang['create_user_validation_identity_label']         = 'Identität';
$lang['create_user_validation_email_label']            = 'E-Mail-Addresse';
$lang['create_user_validation_phone_label']            = 'Telefon';
$lang['create_user_validation_company_label']          = 'Company Name';
$lang['create_user_validation_password_label']         = 'Passwort';
$lang['create_user_validation_password_confirm_label'] = 'Passwort Bestätigung';

// Edit User
$lang['edit_user_heading']                           = 'Benutzer bearbeiten';
$lang['edit_user_subheading']                        = 'Bitte geben Sie die untenstehenden Informationen ein.';
$lang['edit_user_fname_label']                       = 'Vorname';
$lang['edit_user_lname_label']                       = 'Familienname, Nachname';
$lang['edit_user_company_label']                     = 'Name der Firma';
$lang['edit_user_email_label']                       = 'Email';
$lang['edit_user_phone_label']                       = 'Telefon';
$lang['edit_user_password_label']                    = 'Passwort';
$lang['edit_user_password_confirm_label']            = 'Bestätige das Passwort';
$lang['edit_user_password_help']                     = 'wenn das Passwort geändert wird';
$lang['edit_user_groups_heading']                    = 'Mitglied der Gruppen';
$lang['edit_user_submit_btn']                        = 'Benutzer speichern';
$lang['edit_user_validation_fname_label']            = 'Vorname';
$lang['edit_user_validation_lname_label']            = 'Familienname, Nachname';
$lang['edit_user_validation_email_label']            = 'E-Mail-Addresse';
$lang['edit_user_validation_phone_label']            = 'Telefon';
$lang['edit_user_validation_company_label']          = 'Name der Firma';
$lang['edit_user_validation_groups_label']           = 'Gruppen';
$lang['edit_user_validation_password_label']         = 'Passwort';
$lang['edit_user_validation_password_confirm_label'] = 'Passwort Bestätigung';

// Change Password
$lang['change_password_heading']                               = 'Passwort ändern';
$lang['change_password_old_password_label']                    = 'Altes Passwort';
$lang['change_password_new_password_label']                    = 'Neues Passwort (zumindest %s Zeichen lang)';
$lang['change_password_new_password_confirm_label']            = 'Bestätige neues Passwort';
$lang['change_password_submit_btn']                            = 'Veränderung';
$lang['change_password_validation_old_password_label']         = 'Altes Passwort';
$lang['change_password_validation_new_password_label']         = 'Neues Kennwort';
$lang['change_password_validation_new_password_confirm_label'] = 'Bestätige neues Passwort';

// Forgot Password
$lang['forgot_password_heading']                 = 'Passwort vergessen';
$lang['forgot_password_subheading']              = 'Bitte geben Sie Ihre %s So können wir Ihnen eine E-Mail senden, um Ihr Passwort zurückzusetzen.';
$lang['forgot_password_identity_not_found']      = 'Identität nicht gefunden';
$lang['forgot_password_email_label']             = ' %s :';
$lang['forgot_password_submit_btn']              = 'einreichen';
$lang['forgot_password_validation_email_label']  = 'E-Mail-Addresse';
$lang['forgot_password_identity_label']          = 'Benutzername';
$lang['forgot_password_email_identity_label']    = 'Email';
$lang['forgot_password_email_not_found']         = 'Keine Aufzeichnung dieser E-Mail-Adresse.';

// Reset Password
$lang['reset_password_heading']                               = 'Passwort ändern';
$lang['reset_password_new_password_label']                    = 'Neues Passwort (zumindest %s Zeichen lang):';
$lang['reset_password_new_password_confirm_label']            = 'Bestätige neues Passwort:';
$lang['reset_password_submit_btn']                            = 'Veränderung';
$lang['reset_password_validation_new_password_label']         = 'Neues Kennwort';
$lang['reset_password_validation_new_password_confirm_label'] = 'Bestätige neues Passwort';

// Account Creation
$lang['account_creation_successful']            = 'Konto erfolgreich erstellt';
$lang['account_creation_unsuccessful']          = 'Konto konnte nicht erstellt werden';
$lang['account_creation_duplicate_email']       = 'E-Mail bereits verwendet oder ungültig';
$lang['account_creation_duplicate_identity']    = 'Identität bereits verwendet oder ungültig';
$lang['account_creation_missing_default_group'] = 'Standardgruppe ist nicht gesetzt';
$lang['account_creation_invalid_default_group'] = 'Ungültiger Standard-Gruppenname gesetzt';


// Password
$lang['password_change_successful']          = 'Passwort erfolgreich geändert';
$lang['password_change_unsuccessful']        = 'Passwort kann nicht geändert werden';
$lang['forgot_password_successful']          = 'Passwort zurücksetzen E-Mail gesendet';
$lang['forgot_password_unsuccessful']        = 'Passwort konnte nicht zurückgesetzt werden';

// Activation
$lang['activate_successful']                 = 'Konto aktiviert';
$lang['activate_unsuccessful']               = 'Konto konnte nicht aktiviert werden';
$lang['deactivate_successful']               = 'Konto deaktiviert';
$lang['deactivate_unsuccessful']             = 'Konto konnte nicht deaktiviert werden';
$lang['activation_email_successful']         = 'Aktivierungs-E-Mail gesendet. Bitte überprüfen Sie Ihren Posteingang oder Spam';
$lang['activation_email_unsuccessful']       = 'Kann keine Aktivierungs-E-Mail senden';

// Login / Logout
$lang['login_successful']                    = 'Erfolgreich eingeloggt';
$lang['login_unsuccessful']                  = 'Falsche Anmeldedaten';
$lang['login_unsuccessful_not_active']       = 'Konto ist inaktiv';
$lang['login_timeout']                       = 'Vorübergehend gesperrt Versuchen Sie es später noch einmal.';
$lang['logout_successful']                   = 'Abgemeldet';

// Account Changes
$lang['update_successful']                   = 'Kontoinformationen erfolgreich aktualisiert';
$lang['update_unsuccessful']                 = 'Kann keine Kontoinformationen aktualisieren';
$lang['delete_successful']                   = 'Benutzer gelöscht';
$lang['delete_unsuccessful']                 = 'Der Benutzer kann nicht gelöscht werden';

// Groups
$lang['group_creation_successful']           = 'Gruppe erfolgreich erstellt';
$lang['group_already_exists']                = 'Gruppenname bereits genommen';
$lang['group_update_successful']             = 'Gruppendetails aktualisiert';
$lang['group_delete_successful']             = 'Gruppe gelöscht';
$lang['group_delete_unsuccessful']           = 'Die Gruppe kann nicht gelöscht werden';
$lang['group_delete_notallowed']             = 'Kann die Gruppe der Administratoren nicht löschen';
$lang['group_name_required']                 = 'Gruppenname ist ein Pflichtfeld';
$lang['group_name_admin_not_alter']          = 'Admin-Gruppenname kann nicht geändert werden';

// Password Strength
$lang['pass_strength_general']               = "Das Passwort muss haben:";
$lang['pass_strength_minlength']             = "At leaset {{minlength}} characters";
$lang['pass_strength_number']                = "Mindestens eine Nummer";
$lang['pass_strength_capital']               = "Mindestens ein Großbuchstabe";
$lang['pass_strength_special']               = "Mindestens ein Sonderzeichen";

// Emails
$lang['email_caution']                       = '<b>Achtung</b> Der Link kann nur einmal verwendet werden. Wenn Sie versuchen, ein zweites Mal umzuleiten, erscheint ein Fehler. Wenn Sie irgendwelche Fragen haben, mailen Sie bitte unsere Unterstützung an';
$lang['email_automatic']                     = 'Anmerkung: Dieser Brief wurde generiert und automatisch gesendet und benötigt keine Antwort.';
$lang['email_copyright']                     = 'Copyright © %s ';

// Activation Email
$lang['email_activation_subject']            = 'Account Aktivierung';
$lang['email_activate_heading']              = 'Herzlichen Glückwunsch!';
$lang['email_activate_subheading']           = 'Hallo %s Du hast dich erfolgreich registriert';
$lang['email_activate_link']                 = 'Registrierung bestätigen';

// Forgot Password Email
$lang['email_forgotten_password_subject']    = 'Passwort vergessen';
$lang['email_forgot_password_heading']       = 'Hallo %s ,';
$lang['email_forgot_password_subheading']    = 'Wir haben eine Anfrage erhalten, um Ihr Passwort zurückzusetzen. <br> Dein Benutzername ist %s .';
$lang['email_forgot_password_link']          = 'Passwort zurücksetzen';

// New Password Email
$lang['email_new_password_subject']          = 'Neues Kennwort';
$lang['email_new_password_heading']          = 'Neues Kennwort';
$lang['email_new_password_subheading']       = 'Ihr Passwort wurde zurückgesetzt auf:';

// Invoice Email
$lang['emails']                              = 'E-Mails';
$lang['email_to']                            = "Nach";
$lang['email_subject']                       = "Fach";
$lang['email_cc']                            = "CC";
$lang['email_bcc']                           = "BCC";
$lang['show_hide_cc_bcc']                    = "CC &amp; BCC anzeigen / ausblenden";
$lang['send_email']                          = "E-Mail senden";
$lang['emails_list']                         = 'Email (s)';
$lang['send']                                = 'Senden';
$lang['additional_content']                  = 'Zusätzlicher Inhalt';
$lang['emails_example']                      = 'ex: contact@sis.com, info@sis.com ...';
$lang['email_invoice_subject']               = 'Rechnung PDF ab %s ';
$lang['email_invoice_heading']               = 'Grüße!';
$lang['email_invoice_subheading']            = 'Sie haben eine Rechnung erhalten %s . <br> Eine PDF-Datei ist beigefügt.';
$lang['email_successful']                    = 'E-Mail gesendet. Bitte überprüfen Sie Ihren Posteingang oder Spam';
$lang['email_unsuccessful']                  = 'Kann E-Mail nicht senden, überprüfen Sie Ihre E-Mail-Konfiguration!';


$lang['email_dear']                          = 'sehr geehrter %s ,';
$lang['send_payments_reminder']              = 'Sende Zahlungen Erinnerung';
$lang['no_unpaid_invoies']                   = "dieser Kunde hat keine unbezahlten Rechnungen!";
$lang['email_rinvoice_subject']              = 'Neue Rechnung ab %s ';
$lang['email_rinvoice_subheading']           = 'Sie haben eine neue, unbezahlte Rechnung erhalten %s .';
$lang['email_unpaid_subject']                = 'Sie haben unbezahlte Rechnungen aus %s ';
$lang['email_unpaid_invoices']               = 'Du hast %s unbezahlte Rechnungen.';
$lang['email_overdue_subject']               = 'Sie haben überfällige Rechnung von %s ';
$lang['email_overdue_reminder']              = 'Vielleicht haben Sie das Zahlungsdatum verpasst und die Rechnung ist jetzt überfällig %s Tage.';

$lang['overdue_reminder']                    = "Überfällige Erinnerung";
$lang['once_is']                             = "Einmal ist die Rechnung";
$lang['days_late']                           = "tage spät";
$lang['and_every']                           = "und jeder";
$lang['days_after']                          = "Tage später";

/* --------------------------- DATATABLES --------------------------------------------- */
$lang['loading_data']               =   "Daten vom Server laden";
$lang['sEmptyTable']                =   "Keine Ergebnisse in Tabellen gefunden";
$lang['no_data']                    =   "Keine Einträge gefunden !";
$lang['sInfo']                      =   "Anzeige _START_ zu _END_ von _TOTAL_ Zeilen";
$lang['sInfoEmpty']                 =   "Zeige 0 von 0 von 0 Zeilen";
$lang['sInfoFiltered']              =   "(Gefiltert aus _MAX_ Gesamteinträgen)";
$lang['sInfoPostFix']               =   "";
$lang['sInfoThousands']             =   ",";
$lang['sLengthMenu']                =   "_MENU_ Zeilen anzeigen";
$lang['sLoadingRecords']            =   "Laden...";
$lang['sProcessing']                =   "Wird bearbeitet...";
$lang['sSearch']                    =   "Suche";
$lang['advanced_search']            =   "Erweiterte Suche";
$lang['sZeroRecords']               =   "Keine Einträge gefunden";
$lang['sFirst']                     =   "&lt;&lt;";
$lang['sLast']                      =   "&gt;&gt;";
$lang['sNext']                      =   "Aufgaben";
$lang['sPrevious']                  =   "&lt;";
$lang['sSortAscending']             =   ": Aufsteigende Arrangement aktivieren";
$lang['sSortDescending']            =   ": Downlink-Anordnung aktivieren";
$lang['colvis_buttonText']          =   "Spalten anzeigen / ausblenden";
$lang['colvis_sRestore']            =   "Original wiederherstellen";
$lang['colvis_sShowAll']            =   "Zeige alles";
$lang['tabletool_csv']              =   "CSV herunterladen";
$lang['tabletool_xls']              =   "Excel herunterladen";
$lang['tabletool_copy']             =   "Kopieren";
$lang['tabletool_pdf']              =   "PDF Herunterladen";
$lang['tabletool_text']             =   "Text herunterladen";
$lang['tabletool_print']            =   "Drucken";
$lang['tabletool_print_sInfo']      =   "<H6> Druckvorschau </ h6><p> Bitte verwenden Sie die Druckfunktion Ihres Browsers, um diese Tabelle zu drucken. Drücken Sie Esc, wenn Sie fertig sind. </p>";
$lang['tabletool_print_sToolTip']   =   "Druckansicht anzeigen";
$lang['tabletool_select']           =   "Wählen";
$lang['tabletool_select_single']    =   "Wählen Sie Single";
$lang['tabletool_select_all']       =   "Alles auswählen";
$lang['tabletool_select_none']      =   "Alles auswählen";
$lang['tabletool_ajax']             =   "Ajax-Taste";
$lang['tabletool_collection']       =   "Herunterladen";
$lang['export']                     =   "Export";
$lang['export_csv']                 =   "Export als CSV";
$lang['export_xls']                 =   "Als Excel exportieren";
$lang['export_pdf']                 =   "Als pdf exportieren";
$lang['export_text']                =   "Als Text exportieren";
$lang['all']                        = "Alle";

/* --------------------------- DATERANGE --------------------------------------------- */
$lang['daterange_today']            = "Heute";
$lang['daterange_yesterday']        = "Gestern";
$lang['daterange_last_7_days']      = "Letzten 7 Tage";
$lang['daterange_last_30_days']     = "Letzte 30 Tage";
$lang['daterange_this_month']       = "Diesen Monat";
$lang['daterange_last_month']       = "Im vergangenen Monat";
$lang['daterange_this_year']        = "Dieses Jahr";
$lang['daterange_custom']           = "Benutzerdefinierten Bereich";
$lang['daterange_end_of_last_month']= "Ende des letzten Monats";
$lang['daterange_end_of_year']      = "End of last year";

$lang['error']                      = 'Fehler';
$lang['success']                    = 'Erfolg';

// Register
$lang['register_heading']           = 'Neu registrieren';
$lang['register_subheading']        = 'Erstelle deinen Account';
$lang['register_ask']               = 'Du hast kein Konto?';
$lang['register_btn']               = 'Jetzt registrieren!';
$lang['register_username']          = 'Benutzername';
$lang['register_email']             = 'E-Mail-Addresse';
$lang['register_password']          = 'Passwort';
$lang['register_password_confirm']  = 'Bestätige das Passwort';
$lang['register_submit_btn']        = 'Benutzerkonto anlegen';

$lang['default_group']              = 'Neue Kontogruppe';
$lang['enable_register']            = 'Aktivieren Sie das Register';
$lang['reference_type']             = 'Referenztyp';
$lang['show_reference']             = 'Referenz anzeigen';
$lang['reference_type_changed']     = 'Referenzart wird geändert! <br> Sie wollen die Referenzreferenz aller Rechnungen und Schätzungen auf den neuen Typ zurücksetzen?';
$lang['generate']                   = 'Generieren';
$lang['no_invoice_items']           = 'Die Rechnungspositionen sind erforderlich. Muss mindestens 1 Stück mindestens sein';


$lang["loading"]                    = 'Laden...';
$lang["file"]                       = 'Datei';
$lang["shortcut_help"]              = 'Kurzbefehlshilfe';
$lang["shortcut_help_title"]        = 'Tastenkombinationen Hilfe';
$lang["documentations"]             = 'Dokumentationen';
$lang["about"]                      = 'Über';
$lang["shortcut"]                   = 'Abkürzung';
$lang["main_menu"]                  = 'Hauptmenü';

$lang["settings_email"]             = 'E-Mail-Setup';
$lang["configuration_email"]        = 'Email Einstellungen';
$lang["protocol"]                   = 'Protokoll';
$lang["smtp_crypto"]                = 'Beschreibung';
$lang["smtp_host"]                  = 'SMTP-Host';
$lang["smtp_port"]                  = 'SMTP-Port';
$lang["smtp_user"]                  = 'SMTP Benutzer';
$lang["smtp_pass"]                  = 'SMTP-Passwort';
$lang["mailpath"]                   = 'Mail Pfad';
$lang["settings_email_updated"]     = "Die E-Mail-Einstellungen werden erfolgreich aktualisiert";

// importing data
$lang['import_data']                   = "Daten importieren";
$lang['idata_title']                   = "Daten importieren";
$lang['idata_subheading']              = "Welche Daten möchten Sie importieren?";
$lang['idata_upload_file']             = "Datei hochladen";
$lang['idata_upload_file_subheading']  = 'Bitte geben Sie die untenstehenden Informationen ein.';
$lang['idata_match_fields']            = "Spielfelder";
$lang['idata_match_fields_subheading'] = "Passen Sie Ihre Felder an Anwendungsfelder an";
$lang['idata_confirm_data']            = "Datenbestätigung";
$lang['idata_confirm_data_subheading'] = "Bestätigen und löschen Sie Ihre Daten";
$lang['idata_add_to_database']         = "Hinzufügen zu DataBase";
$lang['idata_add_to_db_subheading']    = "Die Ergänzung der Datenbank und der letzte Schritt";
$lang['idata_customers']               = "Kunden importieren";
$lang['idata_customers_description']   = "Importieren von Clients (Namen, Adressen usw.)";
$lang['idata_suppliers']               = "Lieferanten importieren";
$lang['idata_suppliers_description']   = "Importieren von Lieferanten (Namen, Adressen usw.)";
$lang['idata_ex_cats']                 = "Importkosten ändern";
$lang['idata_ex_cats_description']     = "Einfuhrkosten Kategorien (Typ, Etikett)";
$lang['idata_users']                   = "Benutzer importieren";
$lang['idata_users_description']       = "Benutzer importieren (Benutzername, Passwort, E-Mail usw.)";
$lang['idata_tax_rates']               = "Einfuhr von Steuersätzen";
$lang['idata_tax_rates_description']   = "Import von Steuersätzen (Label, Wert und Typ)";
$lang['idata_items']                   = "Artikel importieren";
$lang['idata_items_description']       = "Importieren von Objekten (Name, Beschreibung, Preis usw.)";
$lang['idata_item_cats']               = "Artikelkategorien importieren";
$lang['idata_item_cats_description']   = "Artikelkategorien importieren (Label)";


$lang['idata_info']                    = "Liste der Felder, die Ihre Datendatei enthalten kann. Die fett markierten Felder sind Pflichtfelder. Wenn Sie Daten mit speziellen Symbolen (Kommas, Semikolons usw.) importieren, stellen Sie bitte sicher, dass diese Felder mit Anführungszeichen angegeben sind!";
$lang['idata_checklist']               = "Überprüfen Sie Ihre Liste vor dem Importieren";
$lang['idata_file_format']             = "Format akzeptierte CSV-Dateien (* .csv) oder Excel-Dateien (* .xls, * .xlsx)";
$lang['idata_download_sample_file']    = "Laden Sie eine Beispieldatei herunter, um zu sehen, was wir importieren können.";
$lang['idata_download_sample']         = "Beispieldatei herunterladen";
$lang['idata_csv_delimiter']           = "CSV-Trennzeichen";
$lang['idata_semicolon']               = "Semikolon";
$lang['idata_comma']                   = "Komma";
$lang['idata_tab']                     = "Tab";
$lang['idata_file']                    = "Datei";
$lang['idata_max_file_size']           = "2MB oder 1000 Zeilen maximale Größe";
$lang['idata_delete_item']             = "Entferne diesen Gegenstand";
$lang['idata_items_are_imported']      = "Gegenstände werden importiert";
$lang['idata_item_is_imported']        = "Artikel wird importiert";
$lang['idata_imported']                = "Der Import von Daten wird mit Erfolg abgeschlossen";
$lang['idata_failed']                  = "Der Import von Daten ist fehlgeschlagen.";
$lang['idata_no_data']                 = "Sie fügen keine Daten ein, überprüfen Sie Ihre Eingaben erneut!";


$lang["settings_db"]                   = 'Sicherungen';
$lang["configuration_db"]              = 'DataBase Backups';
$lang["create_backup"]                 = 'Download &amp; Sicherung erstellen';
$lang["date_creation"]                 = "Erstellungsdatum";
$lang["filename"]                      = "Dateiname";
$lang["restore_backup"]                = 'Backup wiederherstellen';
$lang["delete_backup"]                 = 'Sicherung löschen';
$lang["restore_backup_success"]        = "Die Datenbanksicherung wird erfolgreich wiederhergestellt";
$lang["restore_backup_failed"]         = "Die Datenbanksicherung ist fehlgeschlagen";
$lang["backup_deleted"]                = "Die Datenbanksicherung wird erfolgreich gelöscht";



$lang['tax_rate']                      = "Steuersatz";
$lang['settings_tax_rates']            = "Steuersätze";
$lang['configuration_tax_rates']       = "Steuersätze";
$lang["no_tax"]                        = "Keine Steuer";
$lang['create_tax_rate']               = "Steuersatz hinzufügen";
$lang['tax_rate_label']                = "Steuer-Code";
$lang['tax_rate_value']                = "Rate / Betrag";
$lang['tax_rate_type']                 = "Steuersatzart";
$lang['tax_rate_default']              = "Standardsteuersatz";
$lang['tax_rate_new']                  = "Erstellen Sie einen neuen Steuersatz";
$lang['tax_rate_update']               = "Steuernummer aktualisieren";
$lang['tax_rate_added']                = "Steuersatz erfolgreich hinzugefügt";
$lang['tax_rate_updated']              = "Steuersatz erfolgreich aktualisiert";
$lang['tax_rate_deleted']              = "Steuersatz erfolgreich gelöscht";
$lang['condition']                     = "Bedingung";
$lang['conditional_taxes']             = "Bedingte Steuern";
$lang['conditional_taxes_subheading']  = "Fügen Sie Ihren Posts einen Steuersatz hinzu (Rechnung / Schätzung) mit einer Bedingung für die Zwischensumme";
$lang['conditional_taxes_tip']         = "ex: Steuer von 7 $ auf alle Rechnungen hinzufügen hat Zwischensumme größer oder gleich 150 $";
$lang['is_default']                    = "Ist Standard";
$lang['default']                       = "Standard";
$lang['add_tax']                       = "Steuer hinzufügen";
$lang['shipping']                      = "Versand";
$lang['condition_terms']               = "Terms &amp; amp; Bedingungen";
$lang['invoice_note']                  = "Rechnungsnotiz";
$lang['note']                          = "Hinweis";
$lang['set_status']                    = "Status ändern";
$lang['set_status_subheading']         = "Wählen Sie den neuen Status dieser Rechnung";
$lang['old_status']                    = "Alter Status";
$lang['clear_filter']                  = "Filter löschen";
$lang['shown_columns']                 = "Aktive Spalten";
$lang['number_format']                 = "Zahlenformat";
$lang['round_number']                  = "Runde Zahlen";
$lang['decimal_place']                 = "Dezimalstelle";
$lang['disabled']                      = "Behindert";
$lang['enabled']                       = "Aktiviert";
$lang['apply_to_subtotal']             = "Anwenden auf die Anweisung sub total";
$lang['apply_to_line']                 = "Auf Werbebuchungen anwenden";

$lang['estimate']                      = "Schätzen";
$lang['estimates']                     = "Schätzt";
$lang['estimates_subheading']          = "Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['estimate_no']                   = "Schätzung N °";
$lang['estimate_items']                = "Artikel einschätzen";
$lang['estimate_title']                = "Titel schätzen";
$lang['estimate_note']                 = "Schätzung Hinweis";
$lang['create_estimate']               = "Schätzung anlegen";
$lang['create_estimate_subheading']    = "Um eine neue Schätzung zu erstellen, geben Sie bitte die nachfolgenden Informationen ein.";
$lang['estimate_add_success']          = "Schätzung erfolgreich erstellt";
$lang['edit_estimate']                 = "Schätzung bearbeiten";
$lang['edit_estimate_subheading']      = "Um diese Schätzung zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['estimate_edit_success']         = "Schätzung erfolgreich aktualisiert";
$lang['estimate_deleted']              = "Schätzung erfolgreich gelöscht";
$lang['cant_delete_estimate']          = "Sie können diese Schätzung nicht löschen! Ursache: <br><ul><li> Diese Schätzung bezieht sich auf andere Gegenstände </li></ul> Sie müssen alle Artikel löschen und dann erneut versuchen";
$lang['estimate_duplicate_success']    = "Schätzung erfolgreich dupliziert";
$lang['email_estimate_subject']        = "Schätzen Sie PDF aus %s ";
$lang['no_estimate_items']             = "Die Schätzung ist erforderlich. Muss mindestens 1 Stück mindestens sein";
$lang['preview_estimate_error']        = "Um diese Schätzung anzuzeigen, geben Sie bitte alle benötigten Informationen ein.";
$lang['email_estimate_heading']        = 'Grüße!';
$lang['email_estimate_subheading']     = 'Sie haben eine Schätzung erhalten %s . <br> Eine PDF-Datei ist beigefügt.';
$lang['convert_to_invoice']            = "Umrechnung in Rechnung";
$lang['sent']                          = "Gesendet";
$lang['accepted']                      = "Akzeptiert";
$lang['invoiced']                      = "In Rechnung gestellt";
$lang['approve']                       = "Genehmigen";
$lang['reject']                        = "Ablehnen";

$lang['cash']                          = "Kasse";
$lang['check']                         = "Prüfen";
$lang['bank_transfer']                 = "Banküberweisung";
$lang['online']                        = "Online";
$lang['other']                         = "Andere";

$lang['payment']                       = "Zahlung";
$lang['payments']                      = "Zahlungen";
$lang['payments_subheading']           = "Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['payments_create']               = "Zahlung bezahlen";
$lang['payments_create_subheading']    = "Um eine neue Zahlung zu tätigen, geben Sie bitte die unten stehenden Informationen ein.";
$lang['payments_create_success']       = "Zahlung erfolgreich erstellt";
$lang['payments_edit']                 = "Zahlung bearbeiten";
$lang['payments_edit_subheading']      = "Um diese Zahlung zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['payments_edit_success']         = "Zahlung erfolgreich aktualisiert";
$lang['payments_deleted']              = "Zahlung erfolgreich gelöscht";
$lang['payment_number']                = "Zahlungsnummer";
$lang['payment_details']               = "Zahlungsdetails";
$lang['amount']                        = "Menge";
$lang['payment_method']                = "Bezahlverfahren";
$lang['method']                        = "Methode";
$lang['total_paid']                    = "Ganz bezahlt";
$lang['email_payment_subject']         = "Zahlung PDF ab %s ";
$lang['no_payment_items']              = "Die Zahlungsposten sind erforderlich. Muss mindestens 1 Stück mindestens sein";
$lang['preview_payment_error']         = "Um diese Zahlung zu sehen, geben Sie bitte alle benötigten Informationen ein.";
$lang['email_payment_heading']         = 'Grüße!';
$lang['email_payment_subheading']      = 'Sie haben eine Zahlung erhalten von %s . <br> Eine PDF-Datei ist beigefügt.';
$lang['payment_for']                   = "Zahlung für";
$lang['set_status_payment_subheading'] = "Wählen Sie den neuen Status dieser Zahlung";

$lang['receipt']                       = "Zahlungsbeleg";
$lang['receipts']                      = "Zahlungsbelege";
$lang['receipt_no']                    = "Quittung Nr";
$lang['receipt_for']                   = "Quittung für";
$lang['create_receipt']                = "eine Quittung erstellen";
$lang['receipts_create']               = "Quittung anlegen";
$lang['receipts_create_subheading']    = "Um eine neue Quittung zu erhalten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['receipts_edit']                 = "Bearbeiten Sie den Beleg";
$lang['receipts_edit_subheading']      = "Um diese Quittung zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['receipts_create_success']       = "Beleg erfolgreich erstellt";
$lang['receipts_edit_success']         = "Empfang erfolgreich aktualisiert";
$lang['receipts_deleted']              = "Beleg erfolgreich gelöscht";


// PAYMENTS ONLINE
$lang['payments_online']               = "Online-Zahlungen";
$lang['general']                       = "General";
$lang['paypal']                        = "Paypal";
$lang['stripe']                        = "Streifen";
$lang['twocheckout']                   = "2Checkout";
$lang['mobilpay']                      = "MobilPay";
$lang['payments_online_requirements']  = "Dieser Server hat nicht die Mindestanforderungen, um Zahlungen online zu ermöglichen!";
$lang['payments_online_enable']        = "Aktivieren";
$lang['biller_accounts']               = "Biller Konto";
$lang['enable']                        = "Aktivieren";
$lang['username']                      = "Benutzername";
$lang['password']                      = "Passwort";
$lang['sandbox']                       = "Sandkasten";
$lang['enable']                        = "Aktivieren";
$lang['api_key']                       = "API-Schlüssel";
$lang['enable']                        = "Aktivieren";
$lang['account_number']                = "Accountnummer";
$lang['secretWord']                    = "Geheimwort";
$lang['merchant_id']                   = "Kaufmanns-ID";
$lang['public_key']                    = "Öffentlicher Schlüssel";
$lang['test_mode']                     = "Testmodus";
$lang['panding']                       = "steht aus";
$lang['released']                      = "Freigegeben";
$lang['active']                        = "Aktiv";
$lang['expired']                       = "Abgelaufen";
$lang['finished']                      = "Fertig";
$lang['payment_released']              = "Zahlung erfolgreich freigegeben";
$lang['payment_canceled']              = "Die Zahlung wird storniert";



$lang['credit_card']                   = "Kreditkarte";
$lang['credit_card_firstName']         = "Vorname";
$lang['credit_card_lastName']          = "Familienname, Nachname";
$lang['credit_card_number']            = "Kreditkartennummer";
$lang['credit_card_expiryMonth']       = "Ablaufmonat";
$lang['credit_card_expiryYear']        = "Verfalljahr";
$lang['credit_card_cvv']               = "CVV / CVC";

$lang["settings_po_updated"]           = "Die Online-Zahlungseinstellungen werden erfolgreich aktualisiert";

$lang['custom_field']                  = "Benutzerdefinierte Feld";
$lang['custom_fields']                 = "Benutzerdefinierte Felder";
$lang['custom_field_label']            = "Benutzerdefiniertes Feld Etikett";
$lang['custom_field_value']            = "Benutzerdefinierter Feldwert";
$lang['customer_cf']                   = "Kundendefinierte Felder";
$lang['custom_field_1']                = "Benutzerdefiniertes Feld1";
$lang['custom_field_2']                = "Benutzerdefiniertes Feld2";
$lang['custom_field_3']                = "Benutzerdefiniertes Feld3";
$lang['custom_field_4']                = "Benutzerdefiniertes Feld4";
$lang['vat_number']                    = "Umsatzsteuer-Identifikationsnummer";
$lang['vat_number_placeholder']        = "Umsatzsteuer-Identifikationsnummer";



// CUSTOMERS
$lang['customer_bill_to']             = 'Gesetzesentwurf für';
$lang['customer']                     = 'Klient';
$lang['customers']                    = 'Kunden';
$lang['customer_add_success']         = "Client wurde erfolgreich hinzugefügt";
$lang['customer_edit_success']        = "Client erfolgreich aktualisiert";
$lang['customer_deleted']             = "Client erfolgreich gelöscht";
$lang['cant_delete_customer']         = "Sie können diesen Client nicht löschen! Ursache: <br><ul><li> Dieser Kunde steht im Zusammenhang mit einer anderen Rechnung </li></ul> Du musst alle seine Rechnungen löschen und dann nochmal versuchen";
$lang['customers_subheading']         = 'Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.';
$lang['create_customer']              = 'Client hinzufügen';
$lang['edit_customer']                = "Client bearbeiten";
$lang['details_customer']             = "Kundendetails";
$lang['create_customer_subheading']   = "Um einen neuen Kunden hinzuzufügen, geben Sie bitte die unten stehenden Informationen ein.";
$lang['edit_customer_subheading']     = "Um diesen Klienten zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['profile_customer']             = "Kundenprofil";
$lang['profile']                      = "Profil";
$lang['edit_customer_account']        = "Konto bearbeiten";
$lang['create_customer_account']      = "Benutzerkonto anlegen";
$lang['account_created']              = "Clientkonto wurde erfolgreich erstellt";
$lang['account_username']             = "Benutzername";
$lang['account_status']               = "Kontostatus";


// SUPPLIERS
$lang['supplier_bill_to']             = 'Bill von';
$lang['supplier']                     = 'Lieferant';
$lang['suppliers']                    = 'Lieferanten';
$lang['supplier_add_success']         = "Lieferant erfolgreich hinzugefügt";
$lang['supplier_edit_success']        = "Lieferanten erfolgreich aktualisiert";
$lang['supplier_deleted']             = "Lieferant erfolgreich gelöscht";
$lang['cant_delete_supplier']         = "Sie können diesen Lieferanten nicht löschen, Ursache: <br><ul><li> Dieser Lieferant steht mit einer anderen Rechnung in Verbindung </li></ul> Du musst alle seine Rechnungen löschen und dann nochmal versuchen";
$lang['suppliers_subheading']         = 'Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.';
$lang['create_supplier']              = 'Lieferanten hinzufügen';
$lang['edit_supplier']                = "Lieferanten bearbeiten";
$lang['details_supplier']             = "Lieferantendetails";
$lang['create_supplier_subheading']   = "Um einen neuen Lieferanten hinzuzufügen, geben Sie bitte die unten stehenden Informationen ein.";
$lang['edit_supplier_subheading']     = "Um diesen Lieferanten zu bearbeiten, geben Sie bitte unten die Informationen ein.";

// ITEMS
$lang['item']                     = 'Artikel';
$lang['items']                    = 'Artikel';
$lang['price']                    = 'Preis';
$lang['default_tax']              = 'Standardsteuer';
$lang['default_discount']         = 'Default Discount';
$lang['item_add_success']         = "Artikel erfolgreich hinzugefügt";
$lang['item_edit_success']        = "Artikel erfolgreich aktualisiert";
$lang['item_deleted']             = "Element erfolgreich gelöscht";
$lang['cant_delete_item']         = "Sie können diesen Artikel nicht löschen, Ursache: <br><ul><li> Dieser Artikel bezieht sich auf eine andere Rechnung </li></ul> Du musst alle seine Rechnungen löschen und dann nochmal versuchen";
$lang['items_subheading']         = 'Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.';
$lang['create_item']              = 'Artikel hinzufügen';
$lang['edit_item']                = "Element bearbeiten";
$lang['details_item']             = "Artikeldetails";
$lang['create_item_subheading']   = "Um ein neues Element hinzuzufügen, geben Sie bitte die unten stehenden Informationen ein.";
$lang['edit_item_subheading']     = "Um diesen Artikel zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['prices']                   = "Preise";
$lang['unit']                     = "Einheit";
$lang['add_new_price']            = "Neuen Preis hinzufügen";
$lang['no_item_prices']           = "Die Artikelpreise sind erforderlich. Mindestens ein Preis für diesen Artikel muss mindestens sein";
$lang['category']                 = "Kategorie";
$lang['categories']               = "Kategorien";
$lang['items_categories']         = "Kategorien";
$lang['category_create']          = "Neue Kategorie erstellen";
$lang['category_update']          = "Update-Kategorie";
$lang['category_added']           = "Kategorie erfolgreich hinzugefügt";
$lang['category_updated']         = "Kategorie erfolgreich aktualisiert";
$lang['category_deleted']         = "Kategorie erfolgreich gelöscht";


$lang['invoices_activities']      = "Rechnungsaktivitäten";
$lang['estimates_activities']     = "Aktivitäten schätzen";
$lang['activities']               = "Aktivitäten";


$lang['files']                    = "Dateien";
$lang['files_subheading']         = "Dateien";
$lang['file_rename']              = "Umbenennen einer Datei / eines Ordners";
$lang['create_folder']            = "Ordner erstellen";
$lang['file_move_to']             = "Bewegung";
$lang['files_view']               = "Vorschau";
$lang['files_share']              = "Aktie";
$lang['file_deleted']             = "Datei erfolgreich gelöscht";
$lang['file_moved_trash']         = "Datei wurde erfolgreich in den Papierkorb verschoben";
$lang['file_restored']            = "Datei erfolgreich wiederhergestellt";
$lang['cant_delete_file']         = "Sie können diese Datei nicht löschen!";
$lang['file_rename_success']      = "Datei / Ordner erfolgreich umbenannt";
$lang['file_moved_success']       = "Datei / Ordner erfolgreich verschoben";
$lang['create_folder_success']    = "Ordner erfolgreich erstellt";
$lang['filename']                 = "Dateiname";
$lang['size']                     = "Größe";
$lang['file_type']                = "Dateityp";
$lang['upload_date']              = "Datum des Hochladens";
$lang['gohome']                   = "Nach Hause gehen";
$lang['goback']                   = "Geh zurück";
$lang['open_trash']               = "Öffnen Sie den Papierkorb";
$lang['delete_definitive']        = "Endgültig löschen";
$lang['restore_file']             = "Datei wiederherstellen";
$lang['grid']                     = "Rasteransicht";
$lang['list']                     = "Listenansicht";
$lang['sort']                     = "Sortieren";
$lang['upload']                   = "Hochladen";
$lang['share']                    = "Aktie";
$lang['copylink']                 = "Link kopieren";
$lang['copy']                     = "Kopieren";
$lang['move_to']                  = "Ziehen nach";
$lang['move']                     = "Bewegung";
$lang['rename']                   = "Umbenennen";
$lang['foldername']               = "Ordnernamen";
$lang['folder']                   = "Mappe";
$lang['text_is_copied']           = "Text wird in die Zwischenablage kopiert";
$lang['no_file_selected']         = "Keine Datei zum Hochladen ausgewählt!";
$lang['browse_files']             = "Dateien durchsuchen";
$lang['confirm']                  = "Bestätigen";
$lang['dimensions']               = "Maße";
$lang['duration']                 = "Dauer";
$lang['crop']                     = "Ernte";
$lang['rotate']                   = "Drehen";
$lang['choose']                   = "Wählen";
$lang['to_upload']                = "hochladen";
$lang['files_were']               = "Dateien waren";
$lang['file_was']                 = "Datei war";
$lang['chosen']                   = "gewählt";
$lang['drag_drop_file']           = "Drag &amp; Drop Dateien hier";
$lang['or']                       = "oder";
$lang['drop_file']                = "Löschen Sie die Dateien hier zum Hochladen";
$lang['paste_file']               = "Einfügen einer Datei, klicken Sie hier zum Abbrechen.";
$lang['remove_confirmation']      = "Möchten Sie diese Datei wirklich entfernen?";
$lang['folder']                   = "Mappe";
$lang['filesLimit']               = "Nur %s Dateien dürfen hochgeladen werden.";
$lang['filesType']                = "Nur %s Dateien dürfen hochgeladen werden.";
$lang['fileSize']                 = "es ist zu groß! Bitte wählen Sie eine Datei bis zu %s MB";
$lang['filesSizeAll']             = "Dateien, die Sie gewählt haben, sind zu groß! Bitte laden Sie Dateien hoch %s MB";
$lang['fileName']                 = "Datei mit dem Namen %s ist bereits ausgewählt. &#39;";
$lang['folderUpload']             = "Sie dürfen keine Ordner hochladen.";
$lang['no_more_space']            = "Kein Platz mehr zum Hochladen dieser Dateien!";
$lang['add_attached_file']        = "Datei anhängen";
$lang['uploader']                 = "Unterlagen";
$lang['settings_files']           = "Einstellungen uploader";
$lang['configuration_files']      = "Konfiguration zum Hochladen von Dateien";
$lang['file_upload_enable']       = "das Hochladen von Dateien";
$lang['user_disc_space']          = "Speicherplatz für Benutzer";
$lang['user_disc_space_tip']      = "Wie viel Platz jeder Benutzer Dateien dürfen auf Ihrem Server (in Megabyte) zu nehmen.";
$lang['max_upload_size']          = "Maximale Uploadgröße";
$lang['max_upload_size_tip']      = "Die maximale Dateigröße, die Benutzer hochladen können (in Megabyte).";
$lang['max_simult_uploads']       = "Maximale gleichzeitige Uploads.";
$lang['max_simult_uploads_tip']   = "Wie viele Dateien Benutzer können gleichzeitig hochladen.";
$lang['white_list']               = "Weiße Liste";
$lang['white_list_tip']           = "Benutzer können nur Dateien mit diesen Formaten hochladen. Beispiel: mp4, jpg, mp3, pdf.";
$lang["settings_files_updated"]   = "Die Dateien werden erfolgreich aktualisiert";

$lang['send_link_via_email']      = "Senden Sie diesen Link per E-Mail";
$lang['links']                    = "Links";
$lang['view_link']                = "Link anzeigen";
$lang['direct_link']              = "Direkte Verbindung";
$lang['download_link']            = "Download-Link";
$lang['html_embed_code']          = "HTML-Code eingebettet";
$lang['forum_embed_code']         = "Forum eingebettet Code";
$lang['email_file_subject']       = "Datei von %s ";

$lang['folder']                   = "Mappe";
$lang['folder']                   = "Mappe";
$lang['folder']                   = "Mappe";
$lang['folder']                   = "Mappe";
$lang['folder']                   = "Mappe";


// RECURRING INVOICES
$lang['rinvoice']                      = "Wiederkehrende Rechnung";
$lang['rinvoices']                     = "Wiederkehrende Rechnungen";
$lang['rinvoices_subheading']          = "Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['recu_invoice_schedule']         = "Wiederkehrender Rechnungsplan";
$lang['frequency']                     = "Frequenz";
$lang['every']                         = "Jeden";
$lang['occurences']                    = "Vorkommen";
$lang['daily']                         = "Täglich";
$lang['weekly']                        = "Wöchentlich";
$lang['monthly']                       = "Monatlich";
$lang['yearly']                        = "Jährlich";
$lang['day']                           = "Tag";
$lang['days']                          = "Tage";
$lang['week']                          = "Woche";
$lang['weeks']                         = "Wochen";
$lang['month']                         = "Monat";
$lang['months']                        = "Monate";
$lang['year']                          = "Jahr";
$lang['years']                         = "Jahre";
$lang['recu_when_start']               = "Wann wird der automatische Zeitplan gestartet?";
$lang['recu_when_create']              = "Wann werden die Rechnungen erstellt?";
$lang['invoice_will_every']            = "Die Rechnung wird erstellt";
$lang['on']                            = "auf";
$lang['on_the']                        = "auf der";
$lang['forever']                       = "Für immer";
$lang['for']                           = "zum";
$lang['occurence_time']                = "1 mal";
$lang['occurence_times']               = "mal";
$lang['recurring_effective']           = "Wiederkehrende ist wirksam";
$lang['package_name']                  = "Paketnamen";
$lang['create_rinvoice']               = "Erstellen Sie wiederkehrende Rechnung";
$lang['create_rinvoice_subheading']    = "Um eine neue wiederkehrende Rechnung zu erstellen, geben Sie bitte die nachfolgenden Informationen ein.";
$lang['rinvoice_is_canceled']          = "Diese wiederkehrende Rechnung wird abgebrochen, die Sie nicht bearbeitet haben können!";
$lang['edit_rinvoice']                 = "Rezeptive Rechnung bearbeiten";
$lang['edit_rinvoice_subheading']      = "Um diese wiederkehrende Rechnung zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['rinvoices_activities']          = "Wiederkehrende Rechnungsaktivitäten";
$lang['rinvoice_add_success']          = "Wiederkehrende Rechnung erfolgreich erstellt";
$lang['rinvoice_edit_success']         = "Wiederkehrende Rechnung erfolgreich aktualisiert";
$lang['rinvoice_deleted']              = "Wiederkehrende Rechnung erfolgreich gelöscht";
$lang['cant_delete_rinvoice']          = "Sie können diese wiederkehrende Rechnung nicht löschen! Ursache: <br><ul><li> Diese wiederkehrende Rechnung bezieht sich auf andere Gegenstände </li></ul> Sie müssen alle Artikel löschen und dann erneut versuchen";
$lang['rinvoice_duplicate_success']    = "Wiederkehrende Rechnung erfolgreich dupliziert";
$lang['rinvoice_started']              = "Das wiederkehrende Rechnungsprofil wurde erfolgreich gestartet";
$lang['rinvoice_canceled']             = "Das wiederkehrende Rechnungsprofil wird abgebrochen";
$lang['rinvoice_skipped']              = "Wiederkehrende Rechnung hat die nächste Rechnung erfolgreich übersprungen";
$lang['start_profile']                 = "Profil starten";
$lang['cancel_profile']                = "Profil abbrechen";
$lang['skip_next_invoice']             = "Nächste Rechnung überspringen";
$lang['scheduled']                     = "Geplant";
$lang['skipped']                       = "Übersprungen";
$lang['this_invoice_skipped']          = "This invoice is skipped";
$lang['next_billing_date']             = "Nächste Abrechnungsdatum";
$lang['today']                         = "Heute";
$lang['cronjob_desactivated']          = "Um die wiederkehrenden Rechnungen zu aktivieren, müssen Sie diesen Befehl hinzufügen %s auf dem Cron Job in deinem CPanel";
$lang['rinvoice_draft']                = "Sparen Sie die Rechnung als Entwurf bei jedem Vorkommen";
$lang['rinvoice_sent']                 = "E-Mail-Rechnung direkt an den Client bei jedem Auftreten";


// contracts
$lang['contract']                      = "Vertrag";
$lang['contracts']                     = "Verträge";
$lang['contracts_subheading']          = "Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['create_contract']               = "Neuen Vertrag anlegen";
$lang['create_contract_subheading']    = "Um einen neuen Vertrag zu erstellen, geben Sie bitte die nachfolgenden Informationen ein.";
$lang['edit_contract']                 = "Vertrag bearbeiten";
$lang['edit_contract_subheading']      = "Um diesen Vertrag zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['contract_add_success']          = "Vertragsrechnung erfolgreich erstellt";
$lang['contract_edit_success']         = "Vertragsrechnung erfolgreich aktualisiert";
$lang['contract_deleted']              = "Vertragsrechnung erfolgreich gelöscht";
$lang['cant_delete_contract']          = "Sie können diesen Vertrag nicht löschen, Ursache: <br><ul><li> Diese wiederkehrende Rechnung bezieht sich auf andere Gegenstände </li></ul> Sie müssen alle Artikel löschen und dann erneut versuchen";
$lang['subject']                       = "Fach";
$lang['contract_type']                 = "Vertragstyp";
$lang['contract_value']                = "Vertragswert";
$lang['contract_description']          = "Default Vertragsbeschreibung";
$lang['email_contract_subject']        = "Vertrag PDF ab %s ";
$lang['email_contract_heading']        = 'Grüße!';
$lang['email_contract_subheading']     = 'Sie haben einen Vertrag von %s . <br> Eine PDF-Datei ist angehängt.';


// Expenses
$lang['expense']                       = "Aufwand";
$lang['expenses']                      = "Kosten";
$lang['expenses_subheading']           = "Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['expenses_create']               = "Erstelle neue Kosten";
$lang['expenses_create_subheading']    = "Um einen neuen Aufwand zu erstellen, geben Sie bitte die unten stehenden Informationen ein.";
$lang['expenses_edit']                 = "Bearbeiten Sie den Aufwand";
$lang['expenses_edit_subheading']      = "Um diese Kosten zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['expenses_create_success']       = "Kosten erfolgreich erstellt";
$lang['expenses_edit_success']         = "Kosten erfolgreich aktualisiert";
$lang['expenses_deleted']              = "Kosten erfolgreich gelöscht";
$lang['category']                      = "Kategorie";
$lang['attachments']                   = "Anhänge";
$lang['download_attachments']          = "Anhänge herunterladen";
$lang['invoice_number']                = "Rechnungsnummer";
$lang['expense_number']                = "Aufwandsnummer";
$lang['expenses_category']             = "Category";
$lang['expenses_categories']           = "Kategorien";
$lang['expenses_subheading']           = "Bitte benutzen Sie die untenstehende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['expenses_category_create']      = "Neue Kategorie erstellen";
$lang['expenses_category_update']      = "Kategorie bearbeiten";
$lang['expenses_category_added']       = "Kategorie erfolgreich erstellt";
$lang['expenses_category_updated']     = "Kategorie erfolgreich aktualisiert";
$lang['expenses_category_deleted']     = "Kategorie erfolgreich gelöscht";
$lang['expenses_category_type']        = "Art";
$lang['expenses_category_label']       = "Etikette";
$lang['expense_no']                    = "Aufwand N °";



$lang['amount_in_words']         = 'Betrag in Worten';
$lang['nbr_conjunction']         = 'und';
$lang['nbr_negative']            = 'Negativ';
$lang['nbr_decimal']             = 'Punkt';
$lang['nbr_separator']           = ',';
$lang['nbr_inversed']            = false;
$lang['nbr_0']                   = 'Null';
$lang['nbr_1']                   = 'eins';
$lang['nbr_2']                   = 'zwei';
$lang['nbr_3']                   = 'drei';
$lang['nbr_4']                   = 'vier';
$lang['nbr_5']                   = 'fünf';
$lang['nbr_6']                   = 'sechs';
$lang['nbr_7']                   = 'Sieben';
$lang['nbr_8']                   = 'acht';
$lang['nbr_9']                   = 'neun';
$lang['nbr_10']                  = 'zehn';
$lang['nbr_11']                  = 'elf';
$lang['nbr_12']                  = 'zwölf';
$lang['nbr_13']                  = 'dreizehn';
$lang['nbr_14']                  = 'vierzehn';
$lang['nbr_15']                  = 'fünfzehn';
$lang['nbr_16']                  = 'Sechszehn';
$lang['nbr_17']                  = 'siebzehn';
$lang['nbr_18']                  = 'achtzehn';
$lang['nbr_19']                  = 'neunzehn';
$lang['nbr_20']                  = 'zwanzig';
$lang['nbr_30']                  = 'dreißig';
$lang['nbr_40']                  = 'vierzig';
$lang['nbr_50']                  = 'fünfzig';
$lang['nbr_60']                  = 'sechzig';
$lang['nbr_70']                  = 'siebzig';
$lang['nbr_80']                  = 'achtzig';
$lang['nbr_90']                  = 'neunzig';
$lang['nbr_100']                 = 'hundert';
$lang['nbr_200']                 = 'zweihundert';
$lang['nbr_300']                 = 'dreihundert';
$lang['nbr_400']                 = 'vierhundert';
$lang['nbr_500']                 = 'fünfhundert';
$lang['nbr_600']                 = 'sechshundert';
$lang['nbr_700']                 = 'siebenhundert';
$lang['nbr_800']                 = 'Acht hundert';
$lang['nbr_900']                 = 'neun hundert';
$lang['nbr_1000']                = 'tausend';
$lang['nbr_1000000']             = 'Million';
$lang['nbr_1000000000']          = 'Milliarde';
$lang['nbr_1000000000000']       = 'Billion';
$lang['nbr_1000000000000000']    = 'quadrillion';
$lang['nbr_1000000000000000000'] = 'Trillion';


$lang['report']                    = "Bericht";
$lang['reports']                   = "Berichte";
$lang['report_no_data']            = "Sie haben keine Daten für diesen Zeitraum. Bitte das Datum anpassen";
$lang['profit']                    = "Profitieren";
$lang['income']                    = "Einkommen";
$lang['spending']                  = "Ausgaben";
$lang['total_spending']            = "Gesamtausgaben";
$lang['outstanding_revenue']       = "Hervorragende Einnahmen";
$lang['total_outstanding']         = "Absolut aussergewöhnlich";
$lang['total_profit']              = "Gesamtgewinn";
$lang['total_profit']              = "Gesamtgewinn";
$lang['accounts_aging']            = "Konten Alterung";
$lang['accounts_aging_subheading'] = "Finden Sie heraus, welche Kunden lange Zeit nehmen, um zu bezahlen";
$lang['no_aging_accounts']         = "Keine überfälligen Kunden gefunden. Bitte das Datum anpassen.";
$lang['as_of']                     = "Ab";
$lang['aging_age1']                = "00 - 30 Tage";
$lang['aging_age2']                = "31 - 60 Tage";
$lang['aging_age3']                = "61 - 90 Tage";
$lang['aging_age4']                = "Über 90 Tage";
$lang['from']                      = "Von";
$lang['to']                        = "Nach";
$lang['revenue_by_customer']       = "Umsatz des Kunden";
$lang['invoice_details']           = "Rechnungs-Details";
$lang['total_revenue']             = "Gesamtumsatz";
$lang['total_invoiced']            = "Gesamt in Rechnung gestellt";
$lang['total_due']                 = "Gesamt fällig";
$lang['total_paid']                = "Ganz bezahlt";
$lang['summary']                   = "Zusammenfassung";
$lang['tax_summary']               = "Steuerübersicht";
$lang['tax_name']                  = "Steuer Name";
$lang['taxable_amount']            = "Steuerpflichtiger Betrag";
$lang['net']                       = "Netz";
$lang['profit_loss']               = "Gewinn und Verlust (Graphen)";
$lang['profit_loss_subheading']    = "Hilft, zu bestimmen, was du in den Steuern schuldest und wenn du mehr machst, als du verbringst";
$lang['tax_summary_subheading']    = "Hilft zu bestimmen, wie viel Sie die Regierung in den Umsatzsteuer verdanken";
$lang['invoice_det_subheading']    = "Eine detaillierte Zusammenfassung aller Rechnungen, die Sie über einen Zeitraum gesendet haben";
$lang['revenue_cust_subheading']   = "Einnahmen, die vom Kunden über einen bestimmten Zeitraum kategorisiert wurden";


$lang['chat']                      = "Chatten";
$lang['chat_new_message_from']     = "Neue Nachricht";
$lang['online']                    = "Online";
$lang['offline']                   = "Offline";
$lang['delete_conversation']       = "Konversation löschen";
$lang['type_your_message']         = "Geben Sie Ihre Nachricht ein ...";
$lang['support']                   = "Unterstützung";
$lang['chat_support_label']        = "Unterstützungsname";
$lang['chat_support_id']           = "Unterstützungsadministrator";

$lang['tools']                     = "Werkzeuge";
$lang['low']                       = "Niedrig";
$lang['medium']                    = "Mittel";
$lang['high']                      = "Hoch";
$lang['todo_task']                 = "Aufgabe zu erledigen";
$lang['todo_list']                 = "Aufgabenliste";
$lang['priority']                  = "Priorität";
$lang['mark_as_complete']          = "Als komplett markieren";
$lang['create_todo']               = "Neue Aufgabe erstellen";
$lang['edit_todo']                 = "Aufgabe bearbeiten";
$lang['todo_add_success']          = "Aufgabe erfolgreich erstellt";
$lang['todo_edit_success']         = "Task erfolgreich aktualisiert";
$lang['todo_complete_success']     = "Aufgabe erfolgreich abgeschlossen";
$lang['todo_delete_success']       = "Aufgabe erfolgreich gelöscht";

$lang['calculator']                = "Taschenrechner";

$lang['calendar']                  = "Erinnerungskalender";
$lang['calendar_subheading']       = "Bitte klicken Sie auf das Datum, um eine Erinnerung hinzuzufügen / zu ändern.";
$lang['create_reminder']           = "E-Mail-Erinnerung erstellen";
$lang['create_reminder_subheading']= "Um eine neue Erinnerung hinzuzufügen, geben Sie bitte die unten stehenden Informationen ein.";
$lang['edit_reminder']             = "E-Mail-Erinnerung aktualisieren";
$lang['edit_reminder_subheading']  = "Um diese Erinnerung zu bearbeiten, geben Sie bitte die unten stehenden Informationen ein.";
$lang['reminder_add_success']      = "Erinnerung erfolgreich erstellt";
$lang['reminder_edit_success']     = "Erinnerung erfolgreich aktualisiert";
$lang['reminder_delete_success']   = "Erinnerung erfolgreich gelöscht";
$lang['reminder_for']              = "Erinnerung für ";
$lang['repeat']                    = "Wiederholen";
$lang['repeat_every']              = "Wiederholen Sie alle";
$lang['end_date']                  = "Enddatum";
$lang['no_end']                    = "Kein Ende";
$lang['no_repeat']                 = "Keine Wiederholung";
$lang['reminder_subject']          = "E-Mail Betreff";
$lang['reminder_content']          = "E-Mail-Inhalte";
$lang['untitled_reminder']         = "Unberechtigte Erinnerung";

$lang['notifications']             = "Benachrichtigungen";
$lang['no_notifications']          = "0 Benachrichtigungen";

$lang['exchange']                  = "Geldwechsel";
$lang['exchange_subheading']       = "Wechsel zwischen Währungsraten";
$lang['result']                    = "Ergebnis";
$lang['change']                    = "Veränderung";
$lang['not_supported']             = "Nicht unterstützt";


$lang['permission']                = "Genehmigung";
$lang['permissions']               = "Berechtigungen";
$lang['members_permission']        = "Mitglieder Berechtigungen";
$lang['posts_level_permission']    = "Berechtigungen auf Berechtigungsebene";
$lang['posts_level_permission_p']  = "geben Sie an, welche Beiträge Mitglieder lesen und bearbeiten können";
$lang['posts_tip']                 = "Posts sind Rechnungen, Ruccuring Rechnungen, Schätzungen, Kosten, Verträge";
$lang['read_his_posts']            = "Lesen und bearbeiten Sie Beiträge, die vom Mitglied erstellt wurden";
$lang['read_all_posts']            = "Alle Beiträge lesen und bearbeiten";

$lang['customer_permission']       = "Kunden Berechtigungen";
$lang['customer_pay_methods']      = "Zahlungsmethoden";
$lang['customer_pay_methods_p']    = "geben Sie an, welche Zahlungsmethoden Kunden mit bezahlen können";
$lang['customer_pay_methods_tip']  = "Offline-Methoden (Bargeld, Scheck, Überweisung, andere), Online-Methoden: (Paypal, Stripe, 2Checkout ...)";
$lang['use_all_pay_methods']       = "Verwenden Sie alle Zahlungsmethoden (Online und Offline)";
$lang['use_offline_pay_methods']   = "Verwenden Sie Offline-Zahlungsmethoden";


$lang['link']                           = "Verknüpfung";
$lang['overdue_days']                   = "Overdue days";
$lang['update_email_template']          = "E-Mail-Vorlage aktualisieren";
$lang['email_template_updated']         = "E-Mail-Vorlage wurde erfolgreich aktualisiert";
$lang['template_name']                  = "Vorlagenname";
$lang['template']                       = "Vorlage";
$lang['templates']                      = "Vorlagen";
$lang['activation_code']                = "Aktivierungscode";
$lang['forgotten_password_code']        = "Passwort vergessen";
$lang['send_invoices_to_customer']  = "Rechnungen an den Kunden senden";
$lang['send_receipts_to_customer']  = "Quittungen an den Kunden senden";
$lang['send_rinvoices_to_customer'] = "Wiederkehrende Rechnungen an den Kunden senden";
$lang['send_estimates_to_customer'] = "Schätzungen an den Kunden senden";
$lang['send_contracts_to_customer'] = "Verträge an Kunden senden";
$lang['send_customer_reminder']     = "Kundenerinnerung senden";
$lang['send_overdue_reminder']      = "Überfällige Erinnerung senden";
$lang['send_forgotten_password']    = "Passwort vergessen";
$lang['send_activate']              = "Kontoaktivierungscode senden";
$lang['send_activate_customer']     = "Aktivierungscode des Kundenkontos senden";
$lang['send_file']                  = "Datei senden";


$lang['customize_template']           = "Vorlage anpassen";
$lang['blank']                        = "Leer";
$lang['customize']                    = "Anpassen";
$lang['font_size']                    = "Schriftgröße";
$lang['margin']                       = "Marge";
$lang['tables']                       = "Tabellen";
$lang['bordered']                     = "Angrenzend";
$lang['striped']                      = "Gestreift";
$lang['line_th_height']               = "Überschriftshöhe";
$lang['line_td_height']               = "Zeilenhöhe";
$lang['line_th_bg']                   = "Überschrift Hintergrund";
$lang['line_th_color']                = "Überschrift Textfarbe";
$lang['monocolor']                    = "Einfarbig";
$lang['grayscale']                    = "Graustufen";
$lang['background']                   = "Hintergrund";
$lang['color']                        = "Farbe";
$lang['image']                        = "Bild";
$lang['position']                     = "Position";
$lang['fit']                          = "Passen";
$lang['opacity']                      = "Opazität";
$lang['bg_color']                     = "Hintergrundfarbe";
$lang['txt_color']                    = "Textfarbe";
$lang['stamp']                        = "Briefmarke";
$lang['select_color']                 = "Wähle Farbe";



// projects
$lang['project']                      = "Projekt";
$lang['projects']                     = "Projekte";
$lang['projects_subheading']          = "Verwenden Sie die folgende Tabelle, um die Ergebnisse zu navigieren oder zu filtern.";
$lang['create_project']               = "Neues Projekt erstellen";
$lang['create_project_subheading']    = "Um ein neues Projekt zu erstellen, geben Sie bitte die folgenden Informationen ein.";
$lang['edit_project']                 = "Projekt bearbeiten";
$lang['edit_project_subheading']      = "Um dieses Projekt zu bearbeiten, geben Sie bitte die folgenden Informationen ein.";
$lang['project_add_success']          = "Projekt erfolgreich erstellt";
$lang['project_edit_success']         = "Projekt wurde erfolgreich aktualisiert";
$lang['project_deleted']              = "Projekt wurde erfolgreich gelöscht";
$lang['cant_delete_project']          = "Sie können dieses Projekt nicht löschen!";
$lang['project_name']                 = "Projektname";
$lang['billing_type']                 = "Abrechnungsart";
$lang['total_rate']                   = "Gesamtrate";
$lang['rate_per_hour']                = "Rate pro Stunde";
$lang['estimated_hours']              = "Geschätzte Stunden";
$lang['not_started']                  = "Nicht angefangen";
$lang['in_progress']                  = "In Bearbeitung";
$lang['on_hold']                      = "In Wartestellung";
$lang['fixed_rate']                   = "Fester Zinssatz";
$lang['project_hours']                = "Projektstunden";
$lang['task_hours']                   = "Arbeitszeit";
$lang['deadline']                     = "Frist";
$lang['members']                      = "Mitglieder";
$lang['progress']                     = "Fortschritt";
$lang['task']                         = "Aufgabe";
$lang['tasks']                        = "Aufgaben";
$lang['tasks_list']                   = "Aufgabenliste";
$lang['testing']                      = "Testen";
$lang['complete']                     = "Komplett";
$lang['create_task']                  = "Neue Aufgabe erstellen";
$lang['edit_task']                    = "Aufgabe bearbeiten";
$lang['task_add_success']             = "Aufgabe erfolgreich erstellt";
$lang['task_edit_success']            = "Aufgabe erfolgreich aktualisiert";
$lang['task_complete_success']        = "Aufgabe erfolgreich abgeschlossen";
$lang['task_delete_success']          = "Aufgabe erfolgreich gelöscht";
$lang['project_progress']             = "Projektfortschritt";
$lang['project_informations']         = "Projektinformationen";
$lang['not_completed_tasks']          = "Nicht abgeschlossene Aufgaben";
$lang['days_left']                    = "Tage übrig";
$lang['overview']                     = "Überblick";
$lang['hour_rate']                    = "Stundensatz";
$lang['hour']                         = "Stunde";


$lang['partial_invoices']                = "Teilrechnungen";
$lang['partial_invoices_subheading']     = "Bitte verwenden Sie die Tabelle unten, um zu navigieren oder die Ergebnisse zu filtern.";
$lang['paid_amount']                     = "Bezahlte Menge";
$lang['amount_due']                      = "Fälliger Betrag";
$lang['payment_date']                    = "Zahlungsdatum";
$lang['rate']                            = "Bewertung";
$lang['activate_double_currency']        = "Option Doppelwährung aktivieren";
$lang['filter_customer']                 = "Nach Kunde filtern";
$lang['customer_suggestion_placeholder'] = "Kundenvorschlag";
$lang['daterange']                       = "Datumsbereich";
$lang['filtering']                       = "Filtern";
$lang['partial_invoice_details']         = "Teilrechnungsdetails";
$lang['partial_invoice_det_subheading']  = "Eine detaillierte Zusammenfassung der Teilrechnungen, die Sie zu einem bestimmten Zeitpunkt gesendet haben";
$lang['cost_per_supplier']               = "Kosten pro Lieferant";
$lang['cost_per_supplier_subheading']    = "Kosten kategorisiert pro Lieferant zu einem bestimmten Zeitraum";
$lang['tasks_progress']                  = "Aufgabenfortschritt";
$lang['filter_supplier']                 = "Lieferantenfilter";
$lang['supplier_suggestion_placeholder'] = "Lieferantenvorschlag";
$lang['exchange_api']                    = "Exchange-API";
$lang['create_an_account']               = "Ein Konto erstellen";
$lang['generates_an_api_key']            = "und erzeugt einen API-Schlüssel";


?>
